getDataJen <- function(assessment, include = c("all", "parametric", "regional")) {
  
  include <- match.arg(include)
  
  # get stations 

  varID <- c("latitude", "longitude", "OSPARregion", "region")

  if (include == "all") {
    
    stations <- assessment$timeSeries
    stations <- stations[! stations$shape %in% "open_circle", ]
    stations <- within(stations, type <- ifelse(nypos >= 5, "trend", "status"))

    # order by nypos, so trend stations come first
    
    stations <- stations[order(stations$nypos, decreasing = TRUE), ]
    stations <- stations[c(varID, "type")]
    
  } else if (include == "parametric") {
    
    trendStations <- unique(assessment$trend[varID])
    statusStations <- unique(assessment$status[varID])
    
    trendStations$type <- "trend"
    statusStations$type <- "status"
    
    # ensure trend stations come first
    
    stations <- rbind(trendStations, statusStations)
    
  } else if (include == "regional") {
    
    trendStations <- unique(assessment$regionalTrend[varID])
    statusStations <- unique(assessment$regionalStatus[varID])
    
    trendStations$type <- "trend"
    statusStations$type <- "status"
    
    # ensure trend stations come first
    
    stations <- rbind(trendStations, statusStations)
    
  }

  
  # trend stations come first, so a station will only have type status if it doesn't have trend info
  
  stations <- stations[!duplicated(stations[varID]), ]
  

  # get appropriate colour scheme 
  
  stations <- within(stations, {
    type <- factor(type, levels = c("status", "trend"))
  })
  
  stations <- stations[order(stations$type), ]
  
  row.names(stations) <- NULL
  
  stations
}


getJen <- function(assessment, write = TRUE) {
  wk1 <- getDataJen(assessment, "all")
  wk2 <- getDataJen(assessment, "parametric")
  wk3 <- getDataJen(assessment, "regional")
  out <- merge(wk1, wk2, by = c("latitude", "longitude", "OSPARregion", "region"), all.x = TRUE, suffixes = c("1", "2"))
  out <- merge(out, wk3, by = c("latitude", "longitude", "OSPARregion", "region"), all.x = TRUE)
  names(out)[names(out) == "type"] <- "type3"
  
  id <- assessment$ID
  
  if (write)
    write.csv(out, file = file.path("data for Jen", paste(id, "stations.csv")), na = "")
  else 
    out
}

lapply(sediment, getJen)

lapply(biota, getJen)

